/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker;

import club.sk1er.patcher.asm.external.forge.ForgeChunkManagerTransformer;
import club.sk1er.patcher.asm.external.forge.ModelLoaderTransformer;
import club.sk1er.patcher.asm.external.forge.loader.ASMModParserTransformer;
import club.sk1er.patcher.asm.external.forge.loader.MinecraftForgeTransformer;
import club.sk1er.patcher.asm.external.forge.loader.ModClassLoaderTransformer;
import club.sk1er.patcher.asm.external.forge.loader.ModContainerFactoryTransformer;
import club.sk1er.patcher.asm.external.forge.render.ForgeHooksClientTransformer;
import club.sk1er.patcher.asm.external.forge.render.block.BlockInfoTransformer;
import club.sk1er.patcher.asm.external.forge.render.block.ForgeBlockModelRendererTransformer;
import club.sk1er.patcher.asm.external.forge.render.lighting.LightUtilTransformer;
import club.sk1er.patcher.asm.external.forge.render.lighting.VertexLighterFlatTransformer;
import club.sk1er.patcher.asm.external.forge.render.lighting.VertexLighterSmoothAoTransformer;
import club.sk1er.patcher.asm.external.forge.render.screen.GuiIngameForgeTransformer;
import club.sk1er.patcher.asm.external.forge.render.screen.GuiModListTransformer;
import club.sk1er.patcher.asm.external.forge.render.screen.GuiUtilsTransformer;
import club.sk1er.patcher.asm.external.lwjgl.KeyboardTransformer;
import club.sk1er.patcher.asm.external.lwjgl.LibraryLWJGLOpenALTransformer;
import club.sk1er.patcher.asm.external.lwjgl.WindowsDisplayTransformer;
import club.sk1er.patcher.asm.external.lwjgl.WindowsKeycodesTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.witherfix.EntityWitherTransformer;
import club.sk1er.patcher.asm.network.NetHandlerPlayClientTransformer;
import club.sk1er.patcher.asm.network.NetHandlerPlayServerTransformer;
import club.sk1er.patcher.asm.network.packet.S0EPacketSpawnObjectTransformer;
import club.sk1er.patcher.asm.network.packet.S34PacketMapsTransformer;
import club.sk1er.patcher.asm.render.particle.EffectRendererTransformer;
import club.sk1er.patcher.asm.render.screen.GuiChatTransformer;
import club.sk1er.patcher.asm.render.screen.GuiNewChatTransformer;
import club.sk1er.patcher.asm.render.screen.GuiPlayerTabOverlayTransformer;
import club.sk1er.patcher.asm.render.screen.InventoryEffectRendererTransformer;
import club.sk1er.patcher.asm.render.world.RenderGlobalTransformer;
import club.sk1er.patcher.asm.render.world.VertexFormatTransformer;
import club.sk1er.patcher.asm.render.world.VisGraphTransformer;
import club.sk1er.patcher.asm.render.world.entity.LayerCustomHeadTransformer;
import club.sk1er.patcher.asm.render.world.entity.LayerHeldItemTransformer;
import club.sk1er.patcher.asm.render.world.entity.RenderFireballTransformer;
import club.sk1er.patcher.asm.render.world.entity.RenderFishTransformer;
import club.sk1er.patcher.asm.render.world.entity.RenderPlayerTransformer;
import club.sk1er.patcher.asm.render.world.entity.RenderSnowballTransformer;
import club.sk1er.patcher.asm.render.world.entity.RenderWitherTransformer;
import club.sk1er.patcher.asm.render.world.entity.RenderXPOrbTransformer;
import club.sk1er.patcher.asm.world.entity.data.nbt.NBTTagCompoundTransformer;
import club.sk1er.patcher.optifine.OptiFineGenerations;
import club.sk1er.patcher.tweaker.PatcherClassWriter;
import club.sk1er.patcher.tweaker.PatcherTweaker;
import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import gg.essential.universal.UDesktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class ClassTransformer
implements IClassTransformer {
    public static final boolean outputBytecode = "true".equals(System.getProperty("patcher.debugBytecode", "false"));
    public static String optifineVersion = "NONE";
    private final Logger logger = LogManager.getLogger((String)"Patcher - Class Transformer");
    private final Multimap<String, PatcherTransformer> transformerMap = ArrayListMultimap.create();
    public static boolean smoothFontDetected;
    public static final Set<String> supportedOptiFineVersions;
    public static OptiFineGenerations generations;

    public ClassTransformer() {
        MixinEnvironment.getCurrentEnvironment().addTransformerExclusion(this.getClass().getName());
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader.getResource("bre/smoothfont/mod_SmoothFont.class") != null) {
                smoothFontDetected = true;
                this.logger.warn("SmoothFont detected, disabling FontRenderer optimizations.");
            }
            this.fetchSupportedOptiFineVersions();
            this.updateOptiFineGenerations();
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader("Config");
            classReader.accept((ClassVisitor)classNode, 1);
            for (FieldNode fieldNode : classNode.fields) {
                if (!fieldNode.name.equals("OF_RELEASE")) continue;
                optifineVersion = (String)fieldNode.value;
                break;
            }
            if (!supportedOptiFineVersions.contains(optifineVersion)) {
                this.logger.info("User has outdated OptiFine. (version: OptiFine-{})", new Object[]{optifineVersion});
                this.haltForOptiFine("Patcher has detected OptiFine " + optifineVersion + ", which is not supported and will crash.\nPlease update to a supported version of OptiFine and try again.\nSupported versions: " + StringUtils.join(supportedOptiFineVersions, (String)", "));
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.registerTransformer(new GuiNewChatTransformer());
        this.registerTransformer(new S0EPacketSpawnObjectTransformer());
        this.registerTransformer(new RenderXPOrbTransformer());
        this.registerTransformer(new RenderFireballTransformer());
        this.registerTransformer(new RenderFishTransformer());
        this.registerTransformer(new RenderSnowballTransformer());
        this.registerTransformer(new RenderGlobalTransformer());
        this.registerTransformer(new RenderPlayerTransformer());
        this.registerTransformer(new GuiUtilsTransformer());
        this.registerTransformer(new GuiPlayerTabOverlayTransformer());
        this.registerTransformer(new NetHandlerPlayClientTransformer());
        this.registerTransformer(new LayerCustomHeadTransformer());
        this.registerTransformer(new NBTTagCompoundTransformer());
        this.registerTransformer(new GuiChatTransformer());
        this.registerTransformer(new VisGraphTransformer());
        this.registerTransformer(new EffectRendererTransformer());
        this.registerTransformer(new VertexFormatTransformer());
        this.registerTransformer(new LayerHeldItemTransformer());
        this.registerTransformer(new NetHandlerPlayServerTransformer());
        this.registerTransformer(new EntityWitherTransformer());
        this.registerTransformer(new S34PacketMapsTransformer());
        this.registerTransformer(new RenderWitherTransformer());
        this.registerTransformer(new LibraryLWJGLOpenALTransformer());
        if (ClassTransformer.isDevelopment()) {
            this.registerTransformer(new InventoryEffectRendererTransformer());
        }
        this.registerTransformer(new ForgeHooksClientTransformer());
        this.registerTransformer(new GuiModListTransformer());
        this.registerTransformer(new ModClassLoaderTransformer());
        this.registerTransformer(new ModelLoaderTransformer());
        this.registerTransformer(new ForgeChunkManagerTransformer());
        this.registerTransformer(new BlockInfoTransformer());
        this.registerTransformer(new VertexLighterFlatTransformer());
        this.registerTransformer(new VertexLighterSmoothAoTransformer());
        this.registerTransformer(new ForgeBlockModelRendererTransformer());
        this.registerTransformer(new MinecraftForgeTransformer());
        this.registerTransformer(new ASMModParserTransformer());
        this.registerTransformer(new LightUtilTransformer());
        this.registerTransformer(new ModContainerFactoryTransformer());
        this.registerTransformer(new GuiIngameForgeTransformer());
        this.registerTransformer(new WindowsDisplayTransformer());
        this.registerTransformer(new WindowsKeycodesTransformer());
        this.registerTransformer(new KeyboardTransformer());
    }

    public static byte[] createTransformer(String transformedName, byte[] bytes, Multimap<String, PatcherTransformer> transformerMap, Logger logger) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        for (PatcherTransformer transformer : transformers) {
            transformer.transform(classNode, transformedName);
        }
        PatcherClassWriter classWriter = new PatcherClassWriter(2);
        try {
            classNode.accept((ClassVisitor)classWriter);
        }
        catch (Throwable e) {
            logger.error("Exception when transforming {} : {}", new Object[]{transformedName, e.getClass().getSimpleName(), e});
        }
        if (outputBytecode) {
            int lastIndex;
            File bytecodeDirectory = new File("bytecode");
            if (!bytecodeDirectory.exists()) {
                bytecodeDirectory.mkdirs();
            }
            if ((lastIndex = transformedName.lastIndexOf(46)) != -1) {
                transformedName = transformedName.substring(lastIndex + 1) + ".class";
            }
            try {
                File bytecodeOutput = new File(bytecodeDirectory, transformedName);
                if (!bytecodeOutput.exists()) {
                    bytecodeOutput.createNewFile();
                }
                try (FileOutputStream os = new FileOutputStream(bytecodeOutput);){
                    os.write(classWriter.toByteArray());
                }
                catch (IOException e) {
                    logger.error("Failed to create bytecode output for {}.", new Object[]{transformedName, e});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classWriter.toByteArray();
    }

    private void registerTransformer(PatcherTransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        return ClassTransformer.createTransformer(transformedName, bytes, this.transformerMap, this.logger);
    }

    private void haltForOptiFine(String message) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.setUndecorated(true);
        frame.setAlwaysOnTop(true);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        JButton openOptifine = new JButton("Open OptiFine Website");
        openOptifine.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    UDesktop.browse((URI)new URI("https://optifine.net/downloads/"));
                }
                catch (Exception ex) {
                    JLabel label = new JLabel();
                    label.setText("Failed to open OptiFine website.");
                    label.setAlignmentX(0.5f);
                    label.setAlignmentY(0.5f);
                }
            }
        });
        JButton close = new JButton("Close");
        close.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PatcherTweaker.invokeExit();
            }
        });
        Object[] options = new Object[]{openOptifine, close};
        JOptionPane.showOptionDialog(frame, message, "Launch Aborted", -1, 0, null, options, options[0]);
        PatcherTweaker.invokeExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSupportedOptiFineVersions() {
        HttpURLConnection connection = null;
        try {
            URL optifineVersions = new URL("https://static.sk1er.club/patcher/optifine.txt");
            connection = (HttpsURLConnection)optifineVersions.openConnection();
            connection.setRequestProperty("User-Agent", "Patcher OptiFine Fetcher");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String version;
                while ((version = reader.readLine()) != null) {
                    supportedOptiFineVersions.add(version);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to read supported OptiFine versions, adding defaults.", (Throwable)e);
            supportedOptiFineVersions.addAll(Arrays.asList("I7", "L5", "M5", "M6_pre1", "M6_pre2", "M6", "G5", "G6_pre1", "G6"));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOptiFineGenerations() {
        HttpURLConnection connection = null;
        try {
            URL optifineGenerations = new URL("https://static.sk1er.club/patcher/optifine_generations.json");
            connection = (HttpsURLConnection)optifineGenerations.openConnection();
            connection.setRequestProperty("User-Agent", "Patcher OptiFine Fetcher");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                generations = (OptiFineGenerations)new Gson().fromJson((Reader)reader, OptiFineGenerations.class);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to read OptiFine generations list. Supplying default supported generations.", (Throwable)e);
            generations = new OptiFineGenerations();
            generations.getIGeneration().add("I7");
            generations.getLGeneration().add("L5");
            generations.getLGeneration().add("L6");
            generations.getMGeneration().add("M5");
            generations.getMGeneration().add("M6_pre1");
            generations.getMGeneration().add("M6_pre2");
            generations.getMGeneration().add("M6");
            generations.getGGeneration().add("G5");
            generations.getGGeneration().add("G6_pre1");
            generations.getGGeneration().add("G6");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static boolean isDevelopment() {
        Object o = Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return o != null && (Boolean)o != false;
    }

    static {
        supportedOptiFineVersions = new HashSet<String>();
    }
}

